<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/EtatRAP"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="EtatRAP"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:16.0pt;
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <div align="center">
            <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p style="line-height:115%;punctuation-wrap:simple;word-break: break-all"><span style="font-size:10.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> - 
                           
                           
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="right" style="text-align:right;line-height:115%; punctuation-wrap:simple;word-break:break-all"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                           
                           
                           <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="100%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr height="0" class="#tech# #fixWidths#"><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="10%" style="border:none" rowspan="1" colspan="1"></td><td width="10%" style="border:none" rowspan="1" colspan="1"></td><td width="10%" style="border:none" rowspan="1" colspan="1"></td><td width="15%" style="border:none" rowspan="1" colspan="1"></td><td width="30%" style="border:none" rowspan="1" colspan="1"></td><td width="15%" style="border:none" rowspan="1" colspan="1"></td></tr><xsl:for-each select="$docbudg/Budget/Compte/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAP_BU_CPT_NumOrdreTxt_0" select="$docbudg/Budget/Compte[(./@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm1" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content89">
                           <b><span></span></b>
                        </xsl:variable><xsl:variable name="className179">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className179" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">8</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content89" /></xsl:call-template></tr><xsl:for-each select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/Service/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0" select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/Service[(./@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content90">
                           <b><span></span></b>
                        </xsl:variable><xsl:variable name="className180">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className180" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">8</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content90" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm" class="PAGE_BREAK"><xsl:variable name="varOdm3" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif">État des Restes à Payer sur pièces prises en charge du 01/01 au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Pièces non soldées au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateNonSolde)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> et situation actualisée au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateSituation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif">Compte de tiers <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@NumCompte)"/></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-family:&#34;Arial&#34;,sans-serif">Service <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/@Service)"/></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="44%" colspan="3" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice : <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm4" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt">BA de <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="8%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="44%" colspan="3" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm5" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content91">
                           <span></span>
                        </xsl:variable><xsl:variable name="className181">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className181" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">8</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content91" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="5%" style="border:solid black 1.0pt;border-top: none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice</span></b></p>
                        </td><td width="5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No bordereau</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No pièce</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No ligne</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date PEC</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Nom du créancier</span></b></p>
                        </td><td width="30%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet de la pièce de dépense</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Solde au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateNonSolde)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><xsl:for-each select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0" select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte[(./@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm6" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content92">
                           <b><span></span></b>
                        </xsl:variable><xsl:variable name="className182">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className182" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content92" /></xsl:call-template><xsl:variable name="content93"> </xsl:variable><xsl:variable name="className183">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className183" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content93" /></xsl:call-template><xsl:variable name="content94"> </xsl:variable><xsl:variable name="className184">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className184" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content94" /></xsl:call-template><xsl:variable name="content95"> </xsl:variable><xsl:variable name="className185">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className185" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content95" /></xsl:call-template><xsl:variable name="content96"> </xsl:variable><xsl:variable name="className186">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className186" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content96" /></xsl:call-template><xsl:variable name="content97"> </xsl:variable><xsl:variable name="className187">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className187" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content97" /></xsl:call-template><xsl:variable name="content98"> </xsl:variable><xsl:variable name="className188">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className188" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">30%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content98" /></xsl:call-template><xsl:variable name="content99"> </xsl:variable><xsl:variable name="className189">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className189" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content99" /></xsl:call-template></tr><xsl:variable name="varOdm7" select="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/LigneRAP"/><xsl:variable name="varOdm8"><xsl:for-each select="$varOdm7"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="content100"><xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/@ExerciceCompte)"/></xsl:variable><xsl:variable name="className190" select="$ligne/@Format"/><xsl:variable name="className191">LIBELLE</xsl:variable><xsl:variable name="className192">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className190, ' ', $className191, ' ', $className192)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content100" /></xsl:call-template><xsl:variable name="content101"><xsl:value-of select="distinct-values($ligne/@NumBordereau)"/></xsl:variable><xsl:variable name="className193" select="$ligne/@Format"/><xsl:variable name="className194">LIBELLE</xsl:variable><xsl:variable name="className195">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className193, ' ', $className194, ' ', $className195)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content101" /></xsl:call-template><xsl:variable name="content102"><xsl:value-of select="distinct-values($ligne/@ReferencePiece)"/></xsl:variable><xsl:variable name="className196" select="$ligne/@Format"/><xsl:variable name="className197">LIBELLE</xsl:variable><xsl:variable name="className198">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className196, ' ', $className197, ' ', $className198)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content102" /></xsl:call-template><xsl:variable name="content103"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@NumLigne"/></xsl:call-template></xsl:variable><xsl:variable name="className199" select="$ligne/@Format"/><xsl:variable name="className200">LIBELLE</xsl:variable><xsl:variable name="className201">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className199, ' ', $className200, ' ', $className201)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content103" /></xsl:call-template><xsl:variable name="content104"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DatePEC)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className202" select="$ligne/@Format"/><xsl:variable name="className203">LIBELLE</xsl:variable><xsl:variable name="className204">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className202, ' ', $className203, ' ', $className204)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content104" /></xsl:call-template><xsl:variable name="content105"><xsl:value-of select="distinct-values($ligne/@Tiers)"/></xsl:variable><xsl:variable name="className205" select="$ligne/@Format"/><xsl:variable name="className206">LIBELLE</xsl:variable><xsl:variable name="className207">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className205, ' ', $className206, ' ', $className207)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content105" /></xsl:call-template><xsl:variable name="content106"><xsl:value-of select="distinct-values($ligne/@ObjetPiece)"/></xsl:variable><xsl:variable name="className208" select="$ligne/@Format"/><xsl:variable name="className209">LIBELLE</xsl:variable><xsl:variable name="className210">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className208, ' ', $className209, ' ', $className210)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content106" /></xsl:call-template><xsl:variable name="content107"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className211" select="$ligne/@Format"/><xsl:variable name="className212">DECIMAL</xsl:variable><xsl:variable name="className213">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className211, ' ', $className212, ' ', $className213)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content107" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm9"><xsl:choose><xsl:when test="count($varOdm8/*) = 0"><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="5%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="5%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="15%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="30%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="15%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm8"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm9/xhtml:tr"></xsl:with-param></xsl:call-template><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm10" select="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/LigneRAP"/><xsl:variable name="content108">Sous-total de l’exercice <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Libelle)"/></xsl:variable><xsl:variable name="className214" select="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className215">LIBELLE</xsl:variable><xsl:variable name="className216">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className214, ' ', $className215, ' ', $className216)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">7</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content108" /></xsl:call-template><xsl:variable name="content109"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className217" select="$blocLignes_DRAP_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className218">DECIMAL</xsl:variable><xsl:variable name="className219">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className217, ' ', $className218, ' ', $className219)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content109" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr xmlns:odm="http://www.axyus.com/2010/odm" class="PAGE_BREAK"><xsl:variable name="varOdm11" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif">État des Restes à Payer sur pièces prises en charge du 01/01 au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Pièces non soldées au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateNonSolde)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> et situation actualisée au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateSituation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif">Compte de tiers <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@NumCompte)"/></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-family:&#34;Arial&#34;,sans-serif">Service <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/@Service)"/></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="44%" colspan="3" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice : <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm12" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="8%" colspan="8" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt">BA de <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="8%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="44%" colspan="3" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm13" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content110">
                           <span></span>
                        </xsl:variable><xsl:variable name="className220">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className220" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">8</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content110" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="5%" style="border:solid black 1.0pt;border-top: none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No bordereau</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No pièce</span></b></p>
                        </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No ligne</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date PEC</span></b></p>
                        </td><td width="6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Nom du créancier</span></b></p>
                        </td><td width="7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet de la pièce de dépense</span></b></p>
                        </td><td width="11%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Solde au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAP_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAP_BU_CPT_Se_NumOrdreTxt_0)]/@DateNonSolde)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm14" select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte/LigneRAP"/><xsl:variable name="content111">Total du service <xsl:value-of select="distinct-values($blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Libelle)"/></xsl:variable><xsl:variable name="className221" select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className222">LIBELLE</xsl:variable><xsl:variable name="className223">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className221, ' ', $className222, ' ', $className223)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">7</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content111" /></xsl:call-template><xsl:variable name="content112"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/TotalService/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className224" select="$blocLignes_DRAP_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className225">DECIMAL</xsl:variable><xsl:variable name="className226">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className224, ' ', $className225, ' ', $className226)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content112" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm15" select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/Service/ExerciceCompte/LigneRAP"/><xsl:variable name="content113">
                           <span></span><b><span>TOTAL DU COMPTE</span></b>
                        </xsl:variable><xsl:variable name="className227" select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className228">LIBELLE</xsl:variable><xsl:variable name="className229">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className227, ' ', $className228, ' ', $className229)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">7</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content113" /></xsl:call-template><xsl:variable name="content114"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/TotalCompte/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className230" select="$blocLignes_DRAP_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className231">DECIMAL</xsl:variable><xsl:variable name="className232">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className230, ' ', $className231, ' ', $className232)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content114" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr><xsl:variable name="varOdm16" select="$docbudg/Budget/Compte/Service/ExerciceCompte/LigneRAP"/><xsl:variable name="content115">
                           <span></span><b><span lang="EN-US">TOTAL GENERAL</span></b>
                        </xsl:variable><xsl:variable name="className233" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className234">LIBELLE</xsl:variable><xsl:variable name="className235">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className233, ' ', $className234, ' ', $className235)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">7</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content115" /></xsl:call-template><xsl:variable name="content116"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/TotalGeneral/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className236" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className237">DECIMAL</xsl:variable><xsl:variable name="className238">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className236, ' ', $className237, ' ', $className238)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content116" /></xsl:call-template></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>